/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.ReinforcedDispenserBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedDropperBlockEntity;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReinforcedDispenserBlock
extends BlockDispenser
implements IReinforcedBlock,
IOverlayDisplay,
IDisguisable {
    private final float destroyTimeForOwner;

    public ReinforcedDispenserBlock() {
        this.func_149722_s();
        this.destroyTimeForOwner = this.getVanillaBlocks().get((int)0).field_149782_v;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.func_180647_a(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public boolean canHarvestBlock(IBlockAccess level, BlockPos pos, EntityPlayer player) {
        return ConfigHandler.alwaysDrop || super.canHarvestBlock(level, pos, player);
    }

    public Material func_149688_o(IBlockState state) {
        return this.convertToVanillaState(state).func_185904_a();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess level, BlockPos pos) {
        return this.convertToVanillaState(state).func_185909_g(level, pos);
    }

    public String getHarvestTool(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestTool(vanillaState);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().isToolEffective(type, vanillaState);
    }

    public int getHarvestLevel(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestLevel(vanillaState);
    }

    public boolean func_149751_l(IBlockState state) {
        return this.convertToVanillaState(state).func_185895_e();
    }

    public float func_149638_a(Entity exploder) {
        return Float.MAX_VALUE;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
        if (!world.field_72995_K && stack.func_82837_s() && (te = world.func_175625_s(pos)) instanceof ReinforcedDispenserBlockEntity) {
            ((ReinforcedDispenserBlockEntity)te).func_190575_a(stack.func_82833_r());
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ReinforcedDispenserBlockEntity te;
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof ReinforcedDispenserBlockEntity && ((te = (ReinforcedDispenserBlockEntity)tileEntity).isOwnedBy((Entity)player) || te.isAllowed((Entity)player))) {
            player.func_71007_a((IInventory)te);
            if (te instanceof ReinforcedDropperBlockEntity) {
                player.func_71029_a(StatList.field_188083_Q);
            } else {
                player.func_71029_a(StatList.field_188085_S);
            }
        }
        return true;
    }

    protected void func_176439_d(World level, BlockPos pos) {
        if (level.func_175625_s(pos) instanceof ReinforcedDispenserBlockEntity) {
            super.func_176439_d(level, pos);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new ReinforcedDispenserBlockEntity();
    }

    @Override
    public List<Block> getVanillaBlocks() {
        return Arrays.asList(Blocks.field_150367_z);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.getLightValue(world, pos);
        }
        return super.getLightValue(state, world, pos);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_177230_c().getSoundType(actualState, world, pos, entity);
        }
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getSoundType(vanillaState, world, pos, entity);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185900_c(world, pos);
        }
        return super.func_185496_a(state, world, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        IBlockState actualState = this.getDisguisedBlockState(world.func_175625_s(pos));
        if (actualState != null && actualState.func_177230_c() != this) {
            actualState.func_185908_a(world, pos, entityBox, collidingBoxes, entity, true);
        } else {
            ReinforcedDispenserBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_180646_a(state, (IBlockAccess)world, pos));
        }
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return IDisguisable.getDisguisedBlockFaceShape(world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return IDisguisable.shouldDisguisedSideBeRendered(state, world, pos, side);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState disguisedState = this.getDisguisedBlockState(world.func_175625_s(pos));
        return disguisedState != null ? disguisedState : state;
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockAccess)world, pos).func_77973_b() == Item.func_150898_a((Block)this);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (IDisguisable.shouldPickBlockDisguise((IBlockAccess)world, pos, player)) {
            return this.getDisguisedStack((IBlockAccess)world, pos);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }
}

